// ----------------------------------------------------------------------------------------------------
// SOUL_MV Font Manager.js
// Author: Soulpour777 - soulxregalia.wordpress.com
// ----------------------------------------------------------------------------------------------------
/*:
* @plugindesc v1.0 This plugin changes the font used in your game.
* @author Soulpour777 - soulxregalia.wordpress.com
*
* @help

SOUL_MV Font Manager.js
Author: Soulpour777 - soulxregalia.wordpress.com

When you are using the font manager, please be
noted that the General1 is the first one to be used.
When the first font is not found on the player's system,
the second font would be used, and so on.


* @param WTC_General1
* @desc Font displayed in the title screen for English, Japanese and other country users. (First Font)
* @default Calibri
* 
* @param WTC_General2
* @desc Font displayed in the title screen for English, Japanese and other country users. (Second Font)
* @default Cambria Math
* 
* @param WTC_General3
* @desc Font displayed in the title screen for English, Japanese and other country users. (Third Font)
* @default Arial
* 
* @param WTC_General4
* @desc Font displayed in the title screen for English, Japanese and other country users. (Fourth Font)
* @default Tahoma
* 
* @param WTC_General5
* @desc Font displayed in the title screen for English, Japanese and other country users. (Fifth Font)
* @default Times New Roman
* 
* @param WTC_General6
* @desc Font displayed in the title screen for English, Japanese and other country users. (Sixth Font)
* @default sans-serif
* 
* @param WTC_Chinese1
* @desc Font displayed in the title screen for Chinese users. (First Font)
* @default SimHei
* 
* @param WTC_Chinese2
* @desc Font displayed in the title screen for Chinese users. (Second Font)
* @default Arial
* 
* @param WTC_Chinese3
* @desc Font displayed in the title screen for Chinese users. (Third Font)
* @default sans-serif
* 
* @param WTC_Korean1
* @desc Font displayed in the title screen for Korean users. (First Font)
* @default Dotum
* 
* @param WTC_Korean2
* @desc Font displayed in the title screen for Korean users. (Second Font)
* @default AppleGothic
* 
* @param WTC_Korean3
* @desc Font displayed in the title screen for Korean users. (Third Font)
* @default sans-serif
*
*/
(function(){

	var SOUL_MV = SOUL_MV || {};
	SOUL_MV.FontStylerCore = SOUL_MV.FontStylerCore || {};

	SOUL_MV.FontStylerCore.chinese1 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_Chinese1'] || 'SimHei';
	SOUL_MV.FontStylerCore.chinese2 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_Chinese2'] || 'Arial';
	SOUL_MV.FontStylerCore.chinese3 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_Chinese3'] || 'sans-serif';
	SOUL_MV.FontStylerCore.korean1 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_Korean1'] || 'Dotum';
	SOUL_MV.FontStylerCore.korean2 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_Korean2'] || 'AppleGothic';
	SOUL_MV.FontStylerCore.korean3 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_Korean3'] || 'sans-serif';
	SOUL_MV.FontStylerCore.general1 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_General1'] || 'Calibri';
	SOUL_MV.FontStylerCore.general2 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_General2'] || 'Cambria Math';
	SOUL_MV.FontStylerCore.general3 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_General3'] || 'Arial';
	SOUL_MV.FontStylerCore.general4 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_General4'] || 'Tahoma';
	SOUL_MV.FontStylerCore.general5 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_General4'] || 'Times New Roman';
	SOUL_MV.FontStylerCore.general6 = PluginManager.parameters('SOUL_MV Font Manager')['WTC_General6'] || 'sans-serif';	

	Window_Base.prototype.standardFontFace = function() {
	    if ($gameSystem.isChinese()) {
	        return SOUL_MV.FontStylerCore.chinese1 + ', ' + SOUL_MV.FontStylerCore.chinese2 + ', ' + SOUL_MV.FontStylerCore.chinese3;
	    } else if ($gameSystem.isKorean()) {
	        return SOUL_MV.FontStylerCore.korean1 + ', ' + SOUL_MV.FontStylerCore.korean2 + ', ' + SOUL_MV.FontStylerCore.korean3;
	    } else {
	        return SOUL_MV.FontStylerCore.general1 + ', ' + SOUL_MV.FontStylerCore.general2 + ', ' + SOUL_MV.FontStylerCore.general3 + ', '  + SOUL_MV.FontStylerCore.general4 + ', ' + SOUL_MV.FontStylerCore.general5  + ', ' + SOUL_MV.FontStylerCore.general6;
	    }
	};

})();